package furny.swing.admin.statistics.chart;

import java.util.Map.Entry;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.TextAnchor;

import furny.furndb.FurnCache;
import furny.ga.logger.DataCache;

/**
 * The Class FurnitureHistogramChart. The charts are just experimental and not
 * documented yet.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class FurnitureHistogramChart implements IChartSettings {
  @Override
  public JFreeChart createChart(final long runId) {
    final DefaultCategoryDataset dataset = new DefaultCategoryDataset();

    for (final Entry<Long, Long> entry : DataCache.getInstance()
        .getFurnitureCount(runId).entrySet()) {
      dataset.addValue(entry.getValue(), entry.getValue(), FurnCache
          .getInstance().getFurniture(entry.getKey()).getName());
    }

    final JFreeChart chart = ChartFactory.createBarChart(null, // Title
        "Furniture", // X-Axis label
        "Count", // Y-Axis label
        dataset, // Dataset
        PlotOrientation.VERTICAL, //
        true, // Show legend
        true, // show tooltips
        false); // show urls

    final CategoryPlot plot = (CategoryPlot) chart.getPlot();

    final ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER,
        TextAnchor.CENTER, TextAnchor.CENTER, 45.0);
    plot.getRenderer().setPositiveItemLabelPosition(p);

    final ValueAxis rangeAxis = plot.getRangeAxis();
    rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
    rangeAxis.setLowerMargin(0.15);
    rangeAxis.setUpperMargin(0.15);

    return chart;
  }

  @Override
  public String toString() {
    return "Furniture histogram";
  }
}
